* Do-file to create new variables holding, for all members within a given household, attributes of particular
* members (household head, first wife)

* use [path]\Benini_STATAdemo_VariablesOnSubgroupAttributes_101108.dta, clear

* variable name   type   format      label      variable label
* ----------------------------------------------------------------------------------------------------------------
* recno           byte   %8.0g                  Record number
* hhcode          str1   %9s                    Household identifier [the group identifier]
* name            str11  %11s                   Name                 [variable of substantive interest]
* relation        str15  %15s                   Relation             [defining attribute of group member]
* gender          str6   %9s                    Gender               [variable of substantive interest]
* age             byte   %8.0g                  Age                  [not used in this example]
* isliterate      byte   %8.0g                  Is literate          [variable of substantive interest]
* ----------------------------------------------------------------------------------------------------------------


* Make sure initial sort order can be re-created, even if no record number variable exists.
* Create temporary record number:
gen temprecno = _n

* Create tags for defining members, create variables and compute values by household.
* Sort on the defining attribute, group ID and record ID (in this order)

* 1. For household heads:
* Create tag for household head [to be on safe side, do not assume unique head in household]
gsort  hhcode relation temprecno
egen tagHHhead = tag(hhcode) if relation == "Household head"
* Create variables of interest:
gsort  hhcode -tagHHhead
gen nameHHhead =  name if  tagHHhead
replace  nameHHhead =  nameHHhead[_n-1] if  tagHHhead==0 &  hhcode ==  hhcode[_n-1]
 
gen genderHHhead =  gender if  tagHHhead
replace  genderHHhead =  genderHHhead[_n-1] if  tagHHhead==0 &  hhcode ==  hhcode[_n-1]

gen literateHHhead =   isliterate if  tagHHhead
replace  literateHHhead =  literateHHhead[_n-1] if  tagHHhead==0 &  hhcode ==  hhcode[_n-1]

* 2. For first wives:
* Create tag for first wife:
gsort  hhcode relation temprecno
egen tagFirstWife = tag(hhcode) if relation == "Wife"
* Create variables of interest:
gsort  hhcode -tagFirstWife
gen nameFirstWife =  name if   tagFirstWife
replace   nameFirstWife=   nameFirstWife[_n-1] if   tagFirstWife==0 &  hhcode ==  hhcode[_n-1]

gen literateFirstWife =   isliterate if   tagFirstWife
replace   literateFirstWife=    literateFirstWife[_n-1] if   tagFirstWife==0 &  hhcode ==  hhcode[_n-1]

sort  temprecno
drop  temprecno tag*

* Label new variables as convenient
describe
codebook  nameHHhead genderHHhead literateHHhead nameFirstWife literateFirstWife

* Save as appropriate.                                    
